<?php
defined('IN_PHPCMS') or exit('No permission resources.');
pc_base::load_app_class('admin','admin',0);
class post extends admin {
    public $scj2cms;
    public $userDb;
    
    public function __construct() {
        //类文件
        $pluginPath=dirname(__FILE__);
        require_once $pluginPath.'/skycaiji2cms/skycaiji2cms.php';
        $pluginUrl=(skycaiji2cms::is_ssl()?'https':'http').'://'.skycaiji2cms::get_Host().WEB_PATH;
        $scj2cms=new skycaiji2cms(
            $pluginPath,
            $pluginUrl,
            pc_base::load_config('system','charset'),
            false
        );
        
        //编码
        if($scj2cms->charset!='utf-8'){
            foreach ($scj2cms->pluginLang as $k=>$v){
                $scj2cms->pluginLang[$k]=iconv('utf-8',$scj2cms->charset.'//IGNORE',$v);
            }
        }
        
        //设置
        $m_db = pc_base::load_model('module_model');
        $pluginConfig = $m_db->get_one(array('module'=>'skycaijipc'));
        $pluginConfig = string2array($pluginConfig['setting']);
        $scj2cms->pluginConfig=is_array($pluginConfig)?$pluginConfig:array();
        //权限判断
        $author=$scj2cms->randLine($scj2cms->pluginConfig['author']);
        $m_db = pc_base::load_model('admin_model');
        if(is_numeric($author)){
            $this->userDb=$m_db->get_one(array('userid'=>$author));
        }else{
            $this->userDb=$m_db->get_one(array('username'=>$author));
        }
        
        if($this->userDb){
            //权限
            $_SESSION['userid'] = $this->userDb['userid'];
            $_SESSION['roleid'] = $this->userDb['roleid'];
            $_POST['pc_hash']=$_SESSION['pc_hash'] = random(6,'abcdefghigklmnopqrstuvwxwyABCDEFGHIGKLMNOPQRSTUVWXWY0123456789');
            
            $this->_set_cookie('admin_username',$this->userDb['username']);
            $this->_set_cookie('siteid',self::return_siteid());
            $this->_set_cookie('userid',$_SESSION['userid']);
            $this->_set_cookie('admin_email',$this->userDb['email']);
        }else{
            $scj2cms->returnJson(0,scjpc_lang('error_author').$author);
        }
        $this->scj2cms=$scj2cms;
        //初始化
        parent::__construct();
    }
    
    private function _set_cookie($var,$val){
        $var = pc_base::load_config('system','cookie_pre').$var;
        $_COOKIE[$var]=sys_auth($val, 'ENCODE', md5(PC_PATH.'cookie'.$var).pc_base::load_config('system','auth_key'));
    }
    public function init(){
        $_POST['dosubmit_continue']=true;
        ob_start();//缓存输出
        register_shutdown_function(array($this,'_scjExitDo'));
        $this->scj2cms->funcApiPost=array($this,'_scjFuncApiPost');
        $this->scj2cms->apiPost();
    }
    
    public function _scjFuncApiPost(){
        $scj2cms=$this->scj2cms;
        if(empty($_POST['title'])){
            $scj2cms->returnJson(0,scjpc_lang('empty_title'));
        }
        if(empty($_POST['content'])){
            $scj2cms->returnJson(0,scjpc_lang('empty_content'));
        }
        if(empty($_POST['catid'])){
            $scj2cms->returnJson(0,scjpc_lang('empty_catid'));
        }
        //栏目
        $m_db = pc_base::load_model('category_model');
        $catid=$_POST['catid'];
        $catDb=null;
        if(is_numeric($catid)){
            $catDb=$m_db->get_one(array('catid'=>$catid));
        }else{
            $catDb=$m_db->get_one(array('catname'=>$catid));
        }
        if(empty($catDb)){
            $scj2cms->returnJson(0,scjpc_lang('error_catid').$catid);
        }else{
            $catid=$_POST['catid']=$catDb['catid'];
        }
        //投票
        $voteid=$_POST['voteid'];
        if($voteid){
            $m_db = pc_base::load_model('vote_subject_model');
            $voteDb=null;
            if(is_numeric($voteid)){
                $voteDb=$m_db->get_one(array('subjectid'=>$voteid));
            }else{
                $voteDb=$m_db->get_one(array('subject'=>$voteid));
            }
            $_POST['voteid']=$voteid=$voteDb?$voteDb['subjectid']:null;
        }
        //默认参数
        $defParams=array('add_introduce'=>0,'introcude_length'=>200,'auto_thumb'=>0,'auto_thumb_no'=>1,'paginationtype'=>0,'maxcharperpage'=>10000,'inputtime'=>date('Y-m-d H:i:s'),'allow_comment'=>1,'readpoint'=>0,'paytype'=>0);
        foreach ($defParams as $k=>$v){
            if(!isset($_POST[$k])){
                $_POST[$k]=$v;
            }
        }
        if(!is_array($_POST['info'])){
            $_POST['info']=array();
        }
        //修改
        if($_POST['posids']){
            $_POST['posids']=explode(',', $_POST['posids']);
        }
        if($_POST['groupids_view']){
            $_POST['groupids_view']=explode(',', $_POST['groupids_view']);
            $_POST['info']['groupids_view']=1;
        }
        if($_POST['linkurl']){
            $_POST['info']['islink']=1;
        }
        if($_POST['template']){
            $_POST['template']=str_replace('.html', '', $_POST['template']);
        }
        //info字段
        $infoKeys=array('title','content','catid','keywords','copyfrom','description','paginationtype','maxcharperpage','posids','voteid','thumb','relation','inputtime','template','allow_comment','readpoint','paytype');
        foreach ($infoKeys as $key){
            $_POST['info'][$key]=$_POST[$key];
            unset($_POST[$key]);
        }
        try {
            require_once PC_PATH.'modules'.DIRECTORY_SEPARATOR.'content'.DIRECTORY_SEPARATOR.'content.php';
            $cnt=new content();
            //自动截取长度
            $category = $cnt->categorys[$catid];
            $modelid = $category['modelid'];
            $fields = getcache('model_field_'.$modelid,'model');
            foreach ($_POST['info'] as $k=>$v){
                if($v&&is_string($v)&&isset($fields[$k])){
                    $maxLen=intval($fields[$k]['maxlength']);
                    if($maxLen>0){
                        $len=strlen($v);
                        if($len>$maxLen){
                            $_POST['info'][$k]=substr($v,0,$maxLen);
                        }
                    }
                }
            }
            //缩略图
            if($_POST['info']['thumb']){
                $thumb=$scj2cms->curl($_POST['info']['thumb'],null,array('nobody'=>1));
                if(!$thumb['success']||!preg_match('/content-Type\s*:\s*image/i', $thumb['header'])){
                    //错误图片
                    $_POST['info']['thumb']=null;
                }
            }
            
            //添加
            $cnt->add();
        }catch(\Exception $ex){
            $scj2cms->returnJson(0,$ex->getMessage());
        }
    }
    
    public function _scjExitDo(){
        $html=ob_get_contents();//获取输出
        $html=trim($html);
        ob_clean();//清理页面
        
        $return=array(
            'id'=>0,
            'target'=>'',
            'desc'=>'',
            'error'=>''
        );
        if(!empty($html)){
            if(strpos($html, '{')===0){
                //是json
                exit($html);
            }else{
                if(preg_match('/<div class="content guery".*?>(.*?)<\/div>/',$html,$merror)){
                    $return['error']=$merror[1];
                    if($return['error']==L('add_success')){
                        //添加成功
                        $catid=$_POST['info']['catid'];
                        $db=pc_base::load_model('content_model');
                        $id=$db->get_one(array('catid'=>$catid),'id','id desc');
                        $id=is_array($id)?$id['id']:0;
                        if($id>0){
                            $return['error']='';
                            $return['id']=$id;
                            $return['target']=$this->scj2cms->pluginUrl.'index.php?m=content&c=index&a=show&catid='.$catid.'&id='.$id;
                        }
                    }
                    if($return['error']&&preg_match('/[a-z]+\_\w+/i', $return['error'],$mlang)){
                        //没有翻译错误信息
                        $mlang=$mlang[0];
                        $lang = SYS_STYLE ? SYS_STYLE : 'zh-cn';
                        include PC_PATH.'languages'.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.'content.lang.php';
                        if(isset($LANG[$mlang])){
                            $return['error']=str_replace($mlang, $LANG[$mlang], $return['error']);
                        }
                    }
                }
            }
        }else{
            $return['error']='failed';
        }
        $this->scj2cms->returnJson($return['id'],$return['error'],$return['target'],$return['desc']);
    }
}
?>