<?php
defined('IN_PHPCMS') or exit('No permission resources.');
require_once dirname(__FILE__).'/templates/lang.php';
pc_base::load_app_class('admin','admin',0);
class skycaijipc extends admin {
    public $scj2cms;
    
    public function __construct() {
        parent::__construct();
        
        $pluginPath=dirname(__FILE__);
        require_once $pluginPath.'/skycaiji2cms/skycaiji2cms.php';
        $pluginUrl=(skycaiji2cms::is_ssl()?'https':'http').'://'.skycaiji2cms::get_Host().WEB_PATH;
        $scj2cms=new skycaiji2cms(
            $pluginPath,
            $pluginUrl,
            pc_base::load_config('system','charset'),
            true
        );
        //编码
        if($scj2cms->charset!='utf-8'){
            foreach ($scj2cms->pluginLang as $k=>$v){
                $scj2cms->pluginLang[$k]=iconv('utf-8',$scj2cms->charset.'//IGNORE',$v);
            }
        }
        
        $this->scj2cms=$scj2cms;
    }
	public function index() {
	    $scj2cms=$this->scj2cms;
	    
	    $uri='&pc_hash='.$_SESSION['pc_hash'].'&menuid='.$_GET['menuid'];
	    $scj2cms->formUrl=$scj2cms->pluginUrl.'index.php?m=skycaijipc&c=skycaijipc&a=index'.$uri;
	    $scj2cms->apiUrl=$scj2cms->pluginUrl.'index.php?m=skycaijipc&c=post';
	    $scj2cms->static['css']=$scj2cms->pluginUrl.'index.php?m=skycaijipc&c=skycaijipc&a=css'.$uri;
	    
	    $scj2cms->funcError=array($this,'_scjFuncPluginError');
	    
	    if($scj2cms->formIsPost()){
	        //提交
	        $scj2cms->funcFormPost=array($this,'_scjFuncFormPost');
	        $scj2cms->formPost();
	    }else{
	        $m_db = pc_base::load_model('module_model');
	        $pluginConfig = $m_db->get_one(array('module'=>'skycaijipc'));
	        $pluginConfig = string2array($pluginConfig['setting']);
	        $scj2cms->pluginConfig=is_array($pluginConfig)?$pluginConfig:array();
	        $scj2cms->formRequired=scjpc_lang('form_required');
	        $scj2cms->formOptional=scjpc_lang('form_optional');
            //修改	        
	        $position=getcache('position','commons');
	        $posids=array();
	        foreach ($position as $v){
	            $posids[$v['posid']]=$v['posid'].':'.$v['name'];
	        }
	        ksort($posids);
	        $scj2cms->formOptional['posids']=sprintf($scj2cms->formOptional['posids'],implode(', ',$posids));
	        
	        $grouplist = getcache('grouplist','member');
	        $groupids=array();
	        foreach($grouplist as $v) {
	            $groupids[$v['groupid']] = $v['groupid'].':'.$v['name'];
	        }
	        ksort($groupids);
	        $scj2cms->formOptional['groupids_view']=sprintf($scj2cms->formOptional['groupids_view'],implode(', ',$groupids));
	        
	        
	        include $this->admin_tpl('skycaijipc');
	    }
	}
	
	/**
	 * 样式
	 */
	public function css(){
	    header('Content-type: text/css');
	    $css=dirname(__FILE__).'/skycaiji2cms/css.css';
	    $css=file_get_contents($css);
	    exit($css);
	}
	
	//表单提交
	public function _scjFuncFormPost($data){
	    $data = array2string($data);
	    $m_db = pc_base::load_model('module_model');
	    $m_db->update(array('setting'=>$data), array('module'=>'skycaijipc'));
	    showmessage(L('operation_success'), '?m=skycaijipc&c=skycaijipc&a=index');
	}
	public function _scjFuncPluginError($msg){
	    showmessage($msg, '?m=skycaijipc&c=skycaijipc&a=index');
	}
}
?>