<?php
function scjpc_lang($key){
    static $lang=array(
        'pc_modulename'=>'远程发布接口',
        'pc_introduce'=>'远程免登录文章发布接口',
        'pc_author'=>'蓝天采集',
        
        'form_required'=>array(
            'title'=>'标题',
            'content'=>'内容',
            'catid'=>'栏目名称或id'
        ),
        'form_optional'=>array(
            'keywords'=>'关键词（默认空，多个用,号分隔）',
            'copyfrom'=>'来源（默认空）',
            'description'=>'摘要（默认空）',
            'add_introduce'=>'【内容】是否截取内容至摘要（默认0，可填入 1:是，0:否）',
            'introcude_length'=>'【内容】截取多少个字符至摘要（默认200）',
            'auto_thumb'=>'【内容】是否获取标题图片（默认0，可填入 1:是，0:否）',
            'auto_thumb_no'=>'【内容】获取第几张图片作为标题图片（默认1）',
            'paginationtype'=>'分页方式（默认0，可填入 0:不分页，1:自动分页，2:手动分页）',
            'maxcharperpage'=>'自动分页字符数（默认10000）',
            'posids'=>'推荐位（默认空，可填入数字 %s，多个用,号分隔）',
            'groupids_view'=>'阅读权限（默认空，可填入数字 %s，多个用,号分隔）',
            'voteid'=>'添加投票（ 默认空，可填入投票标题或id）',
            'thumb'=>'缩略图（默认空，可填入图片网址）',
            'inputtime'=>'发布时间（默认当前时间）',
            'linkurl'=>'转向链接（默认空）',
            'template'=>'内容页模板（默认空，可填入模板文件名）',
            'allow_comment'=>'允许评论（默认1，可填入 0:不允许评论，1:允许评论）',
            'readpoint'=>'阅读收费（默认0，可填入数字）',
            'paytype'=>'收费类型（默认0，可填入 0:点，1:元）'
        ),
        
        'error_author'=>'不存在用户：',
        'empty_title'=>'标题为空',
        'empty_content'=>'内容为空',
        'empty_catid'=>'栏目为空',
        'error_catid'=>'不存在栏目：',
    );
    
    $val=$lang[$key];
    
    $charset=pc_base::load_config('system','charset');
    $charset=strtolower($charset);

    if($charset!='utf-8'){
        if(is_array($val)){
            foreach ($val as $k=>$v){
                $val[$k]=iconv('utf-8',$charset.'//IGNORE',$v);
            }
        }else{
            $val=iconv('utf-8',$charset.'//IGNORE',$val);
        }
    }
    
    return $val;
}


